<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Check Authenticity</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
    document.querySelector(".menu-toggle").addEventListener("click", function() {
        document.querySelector(".nav-links").classList.toggle("active");
    });
</script>
    <style>
    /** header code  */
    
            * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: Arial, sans-serif;
        }

        header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 50px;
            background-color: #222;
            color: white;
        }

        .logo {
            font-size: 1.5rem;
            font-weight: bold;
        }

        .nav-links {
            list-style: none;
            display: flex;
        }

        .nav-links li {
            margin: 0 15px;
        }

        .nav-links a {
            text-decoration: none;
            color: white;
            font-size: 1rem;
            transition: 0.3s;
        }

        .nav-links a:hover {
            color: #f4a261;
        }

        .menu-toggle {
            display: none;
            font-size: 1.8rem;
            cursor: pointer;
        }

        @media (max-width: 768px) {
            .nav-links {
                display: none;
                flex-direction: column;
                background-color: #222;
                position: absolute;
                top: 60px;
                left: 0;
                width: 100%;
                text-align: center;
                padding: 15px 0;
            }

            .nav-links.active {
                display: flex;
            }

            .menu-toggle {
                display: block;
            }
        }
            .footer-bottom {
            text-align: center;
            margin-top: 20px;
            border-top: 1px solid #444;
            padding-top: 15px;
            font-size: 0.9rem;
        }
    /* header done code */
        body {
            background-color: #f4f4f4;
            font-family: Arial, sans-serif;
        }
        .container {
            margin-top: 50px;
        }
        .authenticity-section {
            background: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        }
        .authenticity-heading {
            color: #9fb721;
            font-size: 24px;
            font-weight: bold;
        }
        .subheading {
            font-size: 16px;
            margin-bottom: 10px;
        }
        .form-control {
            height: 45px;
            border-radius: 4px;
            border: 1px solid #9fb721;
            box-shadow: 2px 2px 2px #cccccc;
        }
        .check-now-btn {
            width: 100%;
            background-color: #9fb721;
            color: white;
            border: none;
            padding: 10px;
            font-size: 18px;
            cursor: pointer;
            border-radius: 5px;
        }
        .check-now-btn:hover {
            background-color: #89a01e;
        }
        .alert {
            display: none;
        }
    </style>
</head>
<header>
    <div class="logo"><a href="https://naturyz.in/"><img style="width:65px;" src="logo.webp" alt="Naturyz Logo"></a></div>
    <ul class="nav-links">
        <li><a href="https://naturyz.in/">Home</a></li>
        <li><a href="https://naturyz.in/collections/all-products">Products</a></li>
        <li><a href="https://naturyz.in/pages/about-us">About Us</a></li>
        <li><a href="https://naturyz.in/pages/contact">Contact Us</a></li>
    </ul>
    <div class="menu-toggle">&#9776;</div>
</header>
<body>
    <div class="container">
        <div class="row align-items-center1">
            <div class="col-md-6">
			<h2 class="authenticity-heading">How to Authenticate?</h2>
                <p class="subheading">Watch how to authenticate a Naturyz product</p>
                <img src="QR-code-scan.jpg" alt="QR Code Scan" class="img-fluid" style="border-radius: 10px;">
            </div>
            <div class="col-md-6 authenticity-section">
                <h2 class="authenticity-heading">Check Authenticity</h2>
                <p class="subheading">Know if your Naturyz product is authentic</p>
                <p class="subheading"><strong>Step 1:</strong> Scratch to reveal the Unique code</p>
                <p class="subheading"><strong>Step 2:</strong> Enter the Unique code below and click on "Check Now"</p>
                <div class="screen-reader-response"><p role="status" aria-live="polite" aria-atomic="true"></p> <ul></ul></div>

<div class="alert alert-success alert-dismissible" id="success" style="display:none;">
<span style="color: #d53d28;font-size: 48px;"><i class="ion-android-done-all"></i></span>
    <span id="messageSuccess"> 
Thank you for Validated QR code. it has been verified and you have purchased a authentic product.
	</span>
        <!--span id="couponID">Coupon Code: NX120</span-->
	  <!--a href="#" class="close" data-dismiss="alert" aria-label="close">×</a-->
	  <div class="col-md-12 col-md-12 col-md-12 text-center">
    <input type="submit" value="Try More" id="tryMore" name="Try More" class="wpcf7-form-control validatebtn">
</div>
</div>


<div class="alert alert-danger alert-dismissible" id="errorss" style="display:none;padding-right: 10px;text-align:center;">
	<span><i class="ion-alert-circled" aria-hidden="true"></i> Oops!</span>
<p>Sorry, we do not recognize the code format you've entered.</p>

<p>Please enter the correct code. For more inquiries,please contact our customer care:</p>
<P>+91 1244383553</P>
    <span id="messageDanger"></span>
    <div class="col-md-12 col-md-12 col-md-12 text-center">
    <input type="submit" value="Try Again" id="tryAgain" name="Try Again" class="wpcf7-form-control">
</div>
</div>
                <form id="fupFormCS" method="post">
                    <span class="wpcf7-not-valid-tip" id="errverified" style="display: none;color: #cb000b;
    font-size: 14px !important;">Product is already verified!!</span>
                    <div class="form-group">
                        <label>Enter Unique Code</label>
                        <input type="text" class="form-control" id="sr_no" name="sr_no" placeholder="Unique code" maxlength="8">
                        <span class="wpcf7-not-valid-tip" id="errUniqueCode"  style="display:none;color: #cb000b;
    font-size: 14px !important;">Please enter correct code</span>
    </span>
                    </div>
                    <div class="form-group">
                        <label>Mobile</label>
                        <input type="text" class="form-control" id="phone" name="phone" placeholder="Mobile No." maxlength="10">
                        <span class="wpcf7-not-valid-tip" id="errPhone"  style="display:none;color: #cb000b;
    font-size: 14px !important;">Please enter correct phone number.</span>
    </span>
                    </div>
                    <div class="form-group">
                        <label>Email ID (optional)</label>
                        <input type="email" class="form-control" id="email" name="email" placeholder="Email ID">
                    </div>
                    <button type="button" class="check-now-btn" id="butsaveCS" name="save">Check Now</button>
                    <div class="wpcf7-response-output" aria-hidden="true" style="display:none;"></div>
                </form>
            </div>
        </div>
    </div>
    
    <script>
   //     $(document).ready(function(){
  //        $('#butsaveCS').on('click', function(){
 //               var code = $('#sr_no').val().trim();
 //               if(code === "12345678") {
 //                   alert("Product is authentic");
 //               } else {
 //                   alert("Invalid code, please try again.");
 //               }
 //           });
 //       });
   $('.close').click(function() {
   $('#errorss').hide();
   $('#success').hide();
   $('#fupFormCS').show();
   $("#butsaveCS").removeAttr("disabled");
});

$('#tryAgain').click(function() {
   $('#errorss').hide();
   $('#success').hide();
   $('#fupFormCS').show();
   $("#butsaveCS").removeAttr("disabled");
   $("#errverified").hide();
});

$('#tryMore').click(function() {
   $('#errorss').hide();
   $('#success').hide();
   $('#fupFormCS').show();
   $("#butsaveCS").removeAttr("disabled");
   $("#errverified").hide();
});

function phonenumber(asd){
  var phoneno = /^\d{10}$/;
  if(asd.match(phoneno)){
      return true;
    }else{
        return false;
    }
}
$(document).ready(function() {
	$('#butsaveCS').on('click', function() {
		$("#butsaveCS").attr("disabled", "disabled");
		$("#errUniqueCode").hide();
        $("#errPhone").hide();
		var sr_no = $('#sr_no').val();
		var email = $('#email').val();
		var phone = $('#phone').val();
		if(sr_no.length == 0){
		    $("#errUniqueCode").show();
		    $("#butsaveCS").removeAttr("disabled");
		}
		if(phone.length == 0 || phone.length <10){
	        $("#errPhone").show();
	        $("#butsaveCS").removeAttr("disabled");
	        return;
		}
		
		    if(!phonenumber(phone)){
        	    $("#butsaveCS").removeAttr("disabled");
                $("#success").hide();
        		$("#errorss").show();
        		$('#fupFormCS').hide();
        		$('#messageDanger').html("Phone number is invalid!!");
        		return;
		    }
			$.ajax({
				url: "https://sofyhealthcare.com/authenticity-guaranteed/save.php",
				type: "POST",
				secure: true,
				headers: {
				    'Access-Control-Allow-Origin': '*',
			    },
			    beforeSend: function (xhr) {
			        xhr.setRequestHeader ("Authorization", "Basic " + btoa(""));
			        },

				data: {
					sr_no: sr_no,
					email: email,
					phone: phone
				},
				cache: false,
				success: function(dataResult){
					var dataResult = JSON.parse(dataResult);
					console.log(dataResult);
					if(dataResult.status=='success'){
						$("#butsaveCS").removeAttr("disabled");
						//$('#fupFormCS').find('input:text').val('');
						document.getElementById("fupFormCS").reset();
				// 		if(email.length>0){
				// 		    $('#fupFormCS').find('input:email').val('');    
				// 		}
						$("#success").show();
						$("#errorss").hide();
						$('#fupFormCS').hide();
						//$('#messageSuccess').html(dataResult.message);
						//$('#couponID').html(dataResult.coupon);
					}
					else if(dataResult.status=='error'){
				        $('#fupFormCS').hide();
				        $("#butsaveCS").removeAttr("disabled");
				// 		$('#fupFormCS').find('input:text').val('');
				        $("#success").hide();
						$("#errorss").show();
						$('#messageDanger').html(dataResult.message);
					}else if(dataResult.status=='av'){
				        $("#butsaveCS").removeAttr("disabled");
				        // $("#success").hide();
						$("#errverified").show();
				// 		$('#messageDanger').html(dataResult.message);
					}
					
					
				}
			});
		
	});
	});
    </script>
</body>
<div class="footer-bottom">
    &copy; 2025 Naturyz | All Rights Reserved
</div>
</html>
